/*---------------------------------------------------------------------------*\

	FILE....: tbusy.cpp
	TYPE....: C++ Program
	AUTHOR..: David Rowe
	DATE....: 3/11/01

	Uses two phone lines (ports 1 and 4) to automatically sample hangup
	tone:

	- port 4 dials port 1
	- port 1 goes off hook on ring
	- recording starts on port 4
	- port 1 hangups up after a few seconds
	- sampling stops on port 4 and port 4 goes on-hook

\*--------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

         Voicetronix Voice Processing Board (VPB) Software

         Copyright (C) 1999-2001 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
	 USA

\*---------------------------------------------------------------------------*/

#include "../src/vpbapi.h"

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

int main(int argc, char *argv[])
{
	int       hdial,h;
	VPB_EVENT e;
	char      s[VPB_MAX_STR];
	int       on_hook;
	long      SampleTime;

	if (argc != 3) {
		printf("usage: tbusy NumToDial SampleTime(s)\n");
		exit(0);
	}

	h = vpb_open(1,1);
        hdial = vpb_open(1,4);
	vpb_sethook_sync(hdial, VPB_OFFHOOK);
	printf("Dialing %s down port 4\n", argv[1]);
	vpb_dial_sync(hdial, argv[1]);

	on_hook = 1;
	do {
		while(vpb_get_event_async(&e) == VPB_OK) {
			vpb_translate_event(&e, s);
			printf(s);

			// take channels off-hook on ring
			if (e.type == VPB_RING) {
				vpb_sethook_sync(e.handle,VPB_OFFHOOK);
				on_hook = 0;
			}
		}
		vpb_sleep(100);
	} while(on_hook);

	vpb_record_file_async(hdial, "busy.wav", 0);
	SampleTime = atol(argv[2]);
	printf("Sampling for %ld secs\n", SampleTime);
	vpb_sleep(1000);
	vpb_sethook_sync(h, VPB_ONHOOK);
	vpb_sleep(SampleTime*1000);
	vpb_record_terminate(hdial);

	vpb_close(h);
	vpb_sethook_sync(hdial, VPB_ONHOOK);
	vpb_close(hdial);

	return 0;
}



